//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Apr/27/2012.
//
#include "DNSettings.h"
#include "DNSettingsImpl.h"

const char *DNSettings::CONTEXT_PATH        = "content_path";
const char *DNSettings::WINDOWLAYOUT        = "windowlayout";
const char *DNSettings::WINDOWGEOMETORY     = "windowgeometory";
const char *DNSettings::SERIAL_PORTNAME     = "serial portName";
const char *DNSettings::SERIAL_RATE         = "serial rate";
const char *DNSettings::SERIAL_DATABITS     = "serial databits";
const char *DNSettings::SERIAL_PARITY       = "serial parity";
const char *DNSettings::SERIAL_STOPBITS     = "serial stopbits";
const char *DNSettings::SERIAL_FLOWCONTROL  = "serial flowControl";

const char *DNSettings::CREATORCONTROLLED_WINDOWLAYOUT      = "creatorcontrolled_windowlayout";
const char *DNSettings::CREATORCONTROLLED_WINDOWGEOMETORY   = "creatorcontrolled_windowgeometory";

//static
std::string DNSettings::getValue(const char *key, std::string defaultValue)
{
    return DNSettingsImpl::getValue(key, defaultValue);
}

//static
void DNSettings::setValue(const char *key, std::string value)
{
    DNSettingsImpl::setValue(key, value);
}
