//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Apr/27/2012.
//
#ifndef DNSETTINGS_H
#define DNSETTINGS_H

#include <string>

class DNSettings
{
public:
    static const char *CONTEXT_PATH;
    static const char *WINDOWLAYOUT;
    static const char *WINDOWGEOMETORY;

    static const char *SERIAL_PORTNAME;
    static const char *SERIAL_RATE;
    static const char *SERIAL_DATABITS;
    static const char *SERIAL_PARITY;
    static const char *SERIAL_STOPBITS;
    static const char *SERIAL_FLOWCONTROL;

    static const char *CREATORCONTROLLED_WINDOWLAYOUT;
    static const char *CREATORCONTROLLED_WINDOWGEOMETORY;

    static std::string getValue(const char *key, std::string defaultValue = "");
    static void setValue(const char *key, std::string value);


private:
    DNSettings() {}
};

#endif // DNSETTINGS_H
