//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 12/16/2011.
//

#ifndef __INCLUDE_TKJSBASICCELL__
#define __INCLUDE_TKJSBASICCELL__

#include "TKCell.h"
#include "TKJSCellBase.h"

#include <string>
#include <JavaScriptCore/JavaScriptCore.h>

class TKJSCellCode;
class TKContainer;
class TKJSContainer;
class TKLock;
class TKReceptor;

class TKJSBasicCell : public TKJSCellBase
{
public:
	TKJSBasicCell(TKJSContainer *container, std::string location, std::string name, bool canIntarface = true);
    virtual ~TKJSBasicCell();
	
	virtual bool                doTick(float time);
    virtual bool                doInit();
    virtual bool                doDestroy();
    
private:
    static TKLock               msLock;
    static JSClassRef           mJSAPIClass;
    static JSClassDefinition    mJsClassDef;
    static JSStringRef          mJsstrReceptors;

    void                        constructJSAPI(JSContextRef context);
    
    JSObjectRef                 mJsReceptorValues;
    JSValueRef                  mJName;
    JSValueRef                  mJLocation;

public:
    static JSValueRef           jsAPICB_getAxonValue(
                                                     JSContextRef ctx,
                                                     JSObjectRef object,
                                                     JSStringRef propertyName,
                                                     JSValueRef *exception);

    static bool                 jsAPICB_setAxonValue(
                                                     JSContextRef ctx,
                                                     JSObjectRef object,
                                                     JSStringRef propertyName,
                                                     JSValueRef value,
                                                     JSValueRef *exception);                                                     
    
    static JSValueRef           jsAPICB_getName(
                                                     JSContextRef ctx,
                                                     JSObjectRef object,
                                                     JSStringRef propertyName,
                                                     JSValueRef *exception);

    static JSValueRef           jsAPICB_getLocation(
                                                JSContextRef ctx,
                                                JSObjectRef object,
                                                JSStringRef propertyName,
                                                JSValueRef *exception);

    static void                 jsFinalize(JSObjectRef object);

};

#endif