//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 12/12/2011.
//

#include "TKJSCellCode.h"
#include "TKJSContainer.h"
#include "TKLog.h"
#include "TKCell.h"
#include "TKJSCellBase.h"
#include "TKJSCellCodeInstance.h"
#include "TKDebug.h"
#include "DNUtils.h"
#include <string>

TKCellCodeInstance* TKJSCellCode::createCellCodeInstance(TKCell *owner, const void *data)
{
    TKCellCodeInstance *result = NULL;
    if (mJsConstructorRef)
    {
        JSContextRef jsCtx = mJSContainer->getJSContext();
        
        JSValueRef api[] = {((TKJSCellBase*)owner)->getCellAPI()};
        
        JSObjectRef jobj = JSObjectCallAsConstructor(mJSContainer->getJSContext(), mJsConstructorRef, 1, api, 0);
        result = new TKJSCellCodeInstance(owner, jobj);

        // execute init code 1
        const char * initCode = (char*)data;
        JSStringRef jstrScript = JSStringCreateWithUTF8CString(initCode);
        JSEvaluateScript(jsCtx, jstrScript, jobj, NULL, 1, NULL);
        JSStringRelease(jstrScript);
        
    }
    
    return result;
}

TKJSCellCode::~TKJSCellCode()
{    
}

TKJSCellCode::TKJSCellCode(std::string name, std::string cellapi, TKJSContainer *container, std::string code):
    TKCellCode(name, cellapi),
    mJsConstructorRef(NULL),
    mJSContainer(container)
{
   //parse input js string here..

    std::string jname = getJSEscapeString(name.c_str());
    std::string stmt = parseCellCodeForScriptEngine(jname, code);

    JSContextRef jsCtx = mJSContainer->getJSContext();
    JSObjectRef  jsGlobalObj = mJSContainer->getJSGlobalObject();
    JSStringRef jstrScript = JSStringCreateWithUTF8CString(stmt.c_str());
    JSEvaluateScript(jsCtx, jstrScript, NULL, NULL, 1, NULL);
    JSStringRef jstrClassName = JSStringCreateWithUTF8CString(jname.c_str());
    mJsConstructorRef = (JSObjectRef) JSObjectGetProperty(jsCtx, jsGlobalObj, jstrClassName,NULL);
    JSStringRelease(jstrClassName);
    if (!mJsConstructorRef)
    {
        TKLog::printf("TKJSCellCode ERROR creating:%s", name.c_str());
    }
    
}

