//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 12/21/2011.
//

#include "TKJSCellCodeInstance.h"
#include "TKJSContainer.h"
#include "TKCell.h"
#include "TKDebug.h"

TKJSCellCodeInstance::TKJSCellCodeInstance(TKCell *owner, JSObjectRef jsObject) : TKCellCodeInstance(owner), mJSObject(jsObject)
{

    mContext = ((TKJSContainer*)owner->getContainer())->getJSContext();
    
    JSValueProtect(mContext, jsObject);
    
    JSStringRef jstrDoTick = JSStringCreateWithUTF8CString("doTick");
    JSStringRef jstrDoInit = JSStringCreateWithUTF8CString("doInit");
    JSStringRef jstrDoDestroy = JSStringCreateWithUTF8CString("doDestroy");
    
    if (JSObjectHasProperty(mContext, jsObject, jstrDoTick))
    {
        mJSDoTick = (JSObjectRef)JSObjectGetProperty(mContext, jsObject, jstrDoTick, NULL);
    }
    else
    {
        mJSDoTick = NULL;
        TKLog::printf("JS Syntax error. can't find mandatory method doTick.." );
    }
    
    if (JSObjectHasProperty(mContext, jsObject, jstrDoInit))
    {
        mJSDoInit = (JSObjectRef)JSObjectGetProperty(mContext, jsObject, jstrDoInit, NULL);
    }
    else
    {
        mJSDoInit = NULL;
    }
    
    if (JSObjectHasProperty(mContext, jsObject, jstrDoDestroy))
    {
        mJSDoDestroy = (JSObjectRef)JSObjectGetProperty(mContext, jsObject, jstrDoDestroy, NULL);
    }
    else
    {
        mJSDoDestroy = NULL;
    }
    
    JSStringRelease(jstrDoTick);
    JSStringRelease(jstrDoInit);
    JSStringRelease(jstrDoDestroy);        
}

TKJSCellCodeInstance::~TKJSCellCodeInstance()
{
    if (mContext && mJSObject)
    {
        JSValueUnprotect(mContext, mJSObject);       
    }
    
}

bool TKJSCellCodeInstance::doTick(float time)
{ 
#ifdef DEBUG	
	std::string cellName = getOwner()->getName();
	DEBUG_TRACE("TKJSCellCode::doTick for %s.", cellName.c_str());
#endif
    
    if (mJSDoTick)
    {
        JSValueRef p = JSValueMakeNumber( mContext,time);
        JSValueRef pa[] = {p}; 
        JSObjectCallAsFunction(mContext,mJSDoTick,mJSObject,1,pa,NULL);
    }
	
    return true;
}

bool TKJSCellCodeInstance::doInit()
{
    if (mJSDoInit)
    {
        JSObjectCallAsFunction(mContext,mJSDoInit,mJSObject,0,NULL,NULL);
    }
    return true;    
}

bool TKJSCellCodeInstance::doDestroy()
{
    if (mJSDoDestroy)
    {
        JSObjectCallAsFunction(mContext,mJSDoDestroy,mJSObject,0,NULL,NULL);
    }
    return true;

}
