//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 12/15/2011.
//

#ifndef __INCLUDE_TKJSCONTAINER__
#define __INCLUDE_TKJSCONTAINER__

#include "TKContainer.h"

#include <string>
#include <map>
#include <JavaScriptCore/JavaScriptCore.h>

class TKCell;
class TKJSCellCode;
class TKJSCellBase;

class TKJSContainer : public TKContainer
{
public:
	TKJSContainer();
	virtual ~TKJSContainer();

	virtual TKCell* createCell(std::string theLocation, std::string theName, TKCellCode *cellCode, std::string startupScript);
	virtual TKCellCode* createCellCode(std::string theName, std::string theAPIType, std::string code);
	
	virtual bool doTick(float time);
		
	virtual void setValue(std::string key, float value);
	virtual float getValue(std::string key);
	
	inline JSGlobalContextRef getJSContext() { return mContext; }
	inline JSObjectRef getJSGlobalObject() { return mGlobalObject; }
	
    static const std::string CELLTYPE_JSBASIC;
    static const std::string CELLTYPE_UIBASE;
	
private:
	JSGlobalContextRef mContext;
	JSObjectRef mGlobalObject;      //Global object of the container
    JSObjectRef mJGlobalObject;     //Global property container for TKJSContainer named 'global'
};


#endif
