//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 3/28/2012.
//
#ifndef DNQSBASICSTORAGECELL_H
#define DNQSBASICSTORAGECELL_H

#include "dnqsbasiccell.h"

#include <QtScript/QScriptEngine>
#include <QtScript/QScriptValue>
#include <QObject>

#include <string>

class DNStorageXYZVRecords;

class DNQSBasicStorageCell : public QObject, public DNQSBasicCell
{
public:
    DNQSBasicStorageCell(DNQSContainer *container, std::string location, std::string name, bool canInterfaceIn, bool canInterfaceOut);
    virtual ~DNQSBasicStorageCell();

protected:
    QScriptValue        mQSStorage;
    std::string         mPath;

private:
    int     getCount_storage(const char* key);
    float   getValue_storage(const char *key);
    bool    setValue_storage(const char *key, float value);

    int             getXYZVArrayCount_storage(const char* key);
    DNStorageXYZVRecords*
                    getXYZVArray_storage(const char *key);
    bool            setXYZVArray_storage(const char *key, QScriptValue array);

    static QScriptValue scriptFunction_storage_setValue(QScriptContext *context, QScriptEngine *engine);
    static QScriptValue scriptFunction_storage_getValue(QScriptContext *context, QScriptEngine *engine);
    static QScriptValue scriptFunction_storage_setXYZVArray(QScriptContext *context, QScriptEngine *engine);
    static QScriptValue scriptFunction_storage_getXYZVArray(QScriptContext *context, QScriptEngine *engine);

    static QScriptString mLengthQSString;
    static QScriptString mXQSString;
    static QScriptString mYQSString;
    static QScriptString mZQSString;
    static QScriptString mVQSString;
    static QScriptString mPushQSString;

};

#endif // DNQSBASICSTORAGECELL_H
