//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 2/22/2012.
//
#include "dnqscellbase.h"

#include "dnqscontainer.h"
#include "TKAxon.h"
#include "TKReceptor.h"
#include "TKLog.h"
#include "DNUtils.h"


DNQSCellBase::DNQSCellBase(DNQSContainer *container, std::string location, std::string name, bool canInterfaceIn, bool canInterfaceOut)
    : TKCell(container,location,name,canInterfaceIn, canInterfaceOut)
{
    mEngine = container->getScriptEngine();

    mQSAPIInstance = mEngine->newObject();
    mQSAPIInstance.setProperty("location", QScriptValue(QString::fromStdString(location)),QScriptValue::ReadOnly|QScriptValue::Undeletable);
    mQSAPIInstance.setProperty("name", QScriptValue(QString::fromStdString(name)),QScriptValue::ReadOnly|QScriptValue::Undeletable);

    mQSReceptors = mEngine->newObject();
    mQSAPIInstance.setProperty("receptors", mQSReceptors,QScriptValue::ReadOnly|QScriptValue::Undeletable);

    mAxonValueHandle = mEngine->toStringHandle("axonValue");
}

DNQSCellBase::~DNQSCellBase()
{

}

void DNQSCellBase::prepareValueForScript()
{
    //update receptor values
    for ( TKReceptorMap::iterator it = mReceptors.begin(); it != mReceptors.end(); ++it )
    {
        mQSReceptors.setProperty(QString::fromStdString(it->first), QScriptValue(it->second->getValue()),QScriptValue::ReadOnly);
    }
    //update axonValue
    mQSAPIInstance.setProperty(mAxonValueHandle,QScriptValue(mAxon->getValue()));

    mReceptorValueUpdated = false;

    return;
}

void DNQSCellBase::reflectValueFromScript()
{
    QScriptValue value = mQSAPIInstance.property(mAxonValueHandle);
    mAxon->setValue(value.toNumber());
}

void DNQSCellBase::handleScriptException(const char *funcName)
{
    std::string message = "Script Error! in ";
    message += mLocation;
    message += "#";
    message += funcName;
    if (mEngine->hasUncaughtException())
    {
        QScriptValue error = mEngine->uncaughtException();
        QString errorString = error.toString();
        message += "\n";
        message += errorString.toStdString();
        mEngine->clearExceptions();
    }
    dnNotifyWarning("Script error", message);
}
