//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 2/22/2012.
//
#ifndef DNQSCONTAINER_H
#define DNQSCONTAINER_H

#include "TKContainer.h"

#include <QtScript/QScriptEngine>
#include <QtScript/QScriptValue>

class DNQSContainer : public TKContainer
{
public:
    DNQSContainer();
    virtual ~DNQSContainer();

    virtual void    setValue(std::string key, float value);
    virtual float   getValue(std::string key) const;

    inline QScriptEngine*   getScriptEngine() { return mQSEngine; }
    inline QScriptValue     getScriptGlobalObject() { return mQSGlobalObject; }
    inline QScriptValue     getQSCellContainer() { return mQSCellContainer; }

    virtual TKCell*         cellFactory(std::string location, std::string name, std::string type, bool canInterfaceIn, bool canInterfaceOut);
    virtual TKCell*         pluginCellFactory(std::string location, std::string fullName, std::string type, std::string pluginName, std::string pluginValue, bool canInterfaceIn, bool canInterfaceOut);
    virtual TKAxon*         axonFactory(TKCell *theOwner);
    virtual TKReceptor*     receptorFactory(TKCell *theOwner);
    virtual TKAxonTerminal* axonTerminalFactory(TKAxon *theOwner);
    virtual TKCellCode*     cellCodeFactory(std::string name, std::string cellapi, std::string code);

 private:
    QScriptEngine   *mQSEngine;
    QScriptValue    mQSGlobalObject;
    QScriptValue    mQSCellContainer;
};

#endif // DNQSCONTAINER_H
