//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 3/14/2012.
//
#include "dnqsinputcell.h"

#include "TKContainer.h"
#include "TKAxon.h"

DNQSInputCell::DNQSInputCell(TKContainer *container, std::string location, std::string name):
    DNCellInterfaceable(container,location,name, true, false), mInputValue(0)
{
}

DNQSInputCell::~DNQSInputCell()
{
}

bool DNQSInputCell::doTick(float time)
{
    (void)time;
    return true;
}

bool DNQSInputCell::doInit()
{
    return true;
}

bool DNQSInputCell::doDestroy()
{
    return true;
}

void DNQSInputCell::updateReceptorValue()
{
    mAxon->setValue(mInputValue);
}

void DNQSInputCell::setValue(float value)
{
    mInputValue = value;
    mReceptorValueUpdated = true;
}
