//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 3/14/2012.
//
#ifndef DNQSINPUTCELL_H
#define DNQSINPUTCELL_H

#include "DNCellInterfaceable.h"

class TKContainer;

class DNQSInputCell : public DNCellInterfaceable
{
public:
    DNQSInputCell(TKContainer *container, std::string location, std::string name);
    virtual ~DNQSInputCell();

    virtual bool            doTick(float time);
    virtual bool            doInit();
    virtual bool            doDestroy();

    virtual void            updateReceptorValue();
    virtual void            setValue(float value);

private:
    float           mInputValue;
};

#endif // DNQSINPUTCELL_H
