//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 1/17/2013.
//
#include "dnplugininputcell.h"

#include "TKContainer.h"
#include "TKAxon.h"

#include "dnplugin.h"
#include "dnpluginmanager.h"
#include "DNUtils.h"

#include <limits>

DNPluginInputCell::DNPluginInputCell(TKContainer *container, std::string location, std::string name, std::string pluginName, std::string valueName):
    DNCellInterfaceable(container,location,name, true, false),
    d_plugin(NULL), d_valueName(valueName), d_inputValue(std::numeric_limits<float>::quiet_NaN())
{
    d_plugin = DNPluginManager::instance()->getPlugin(pluginName);
    if (!d_plugin)
    {
        std::string message = std::string("Failed to initialize cell '").append(location).append("#").append(name);
        message.append("'\nLoading the specified plugin : '").append(pluginName).append("' failed");
        dnNotifyError("Initialization failed", message);
    }
}

DNPluginInputCell::~DNPluginInputCell()
{
}

bool DNPluginInputCell::doTick(float time)
{
    (void)time;
    return true;
}

bool DNPluginInputCell::doInit()
{
    return true;
}

bool DNPluginInputCell::doDestroy()
{
    return true;
}

void DNPluginInputCell::updateReceptorValue()
{
    if (d_plugin && d_plugin->getIsValid())
    {
        float v = d_plugin->queryPluginValue(d_valueName.c_str());
        if (v != d_inputValue)
        {
            d_inputValue = v;
            mAxon->setValue(v);
            mReceptorValueUpdated = true;
        }
    }
}

void DNPluginInputCell::setValue(float value)
{
    (void)value;
}
