//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 1/17/2013.
//
#ifndef DNPLUGINOUTPUTCELL_H
#define DNPLUGINOUTPUTCELL_H

#include "DNCellInterfaceable.h"

class DNPlugin;

class DNPluginOutputCell : public DNCellInterfaceable
{
    DNPlugin                *d_plugin;
    std::string             d_valueName;
    float                   d_outputValue;
    bool                    d_wasReady;
    TKReceptorMap::iterator d_valueIterator;
    TKReceptorMap::iterator d_forceUpdateIterator;

public:
    DNPluginOutputCell(TKContainer *container, std::string location, std::string name, std::string pluginName, std::string valueName);
    virtual ~DNPluginOutputCell();

    virtual bool doTick(float time);
    virtual bool doInit();
    virtual bool doDestroy();

    virtual void setValue(float value);
};

#endif // DNPLUGINOUTPUTCELL_H
