//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 1/7/2012.
//

#include "DNDirectoryImpl.h"
#include "TKLog.h"

#include "OSXDNDirectoryImpl.h"


//static
DNDirectoryImpl* DNDirectoryImpl::create(const char *dir)
{
    return new OSXDNDirectoryImpl(dir);    
}


OSXDNDirectoryImpl::OSXDNDirectoryImpl(const char *dir) : mFileList(0)
{
    mRootDir = [[NSString alloc] initWithUTF8String:dir];    
}

OSXDNDirectoryImpl::~OSXDNDirectoryImpl()
{
    cleanFileList();
}

void OSXDNDirectoryImpl::cleanFileList()
{
    DNFileList *file = mFileList;
    mFileList = 0;
    while(file)
    {
        DNFileList *next = file->next;
        delete file;
        file = next;
    }    
}

const DNFileList* OSXDNDirectoryImpl::getFileList(const char *filter)
{
    cleanFileList();
    
    NSString *nfilter = [[NSString alloc] initWithUTF8String:filter];
    NSError *error = NULL;
    NSRegularExpression *regex = [NSRegularExpression regularExpressionWithPattern:nfilter
                                                                           options: NSRegularExpressionCaseInsensitive
                                                                             error:&error];
    
    NSFileManager* fileManager = [NSFileManager defaultManager];
    NSDirectoryEnumerator *dirEnum =[fileManager enumeratorAtPath:mRootDir];
    
    NSString *file;
    mFileList = 0;
    DNFileList *prev = 0;
    while (file = [dirEnum nextObject]) {
        NSString *fileExt = [file pathExtension];
        NSUInteger m = [regex numberOfMatchesInString:fileExt
                               options:0
                                 range:NSMakeRange(0, [fileExt length])];

        if (m > 0)
        {
            DNFileList *dnfile = new DNFileList([file UTF8String]);
            if (prev)
            {
                prev->next = dnfile;
                prev = dnfile;
            }
            else
            {
                mFileList = dnfile;
                prev = dnfile;
            }
        }
    }
    
    return mFileList;
}
