//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 1/7/2012.
//

#include "OSXDNTimeKeeperImpl.h"
#include "TKLog.h"

DNTimeKeeperImpl* DNTimeKeeperImpl::create()
{
    return new OSXDNTimeKeeperImpl();
}

OSXDNTimeKeeperImpl::OSXDNTimeKeeperImpl(): 
    mIntervalTime(1.0), 
    mAvgActualInterval(1.0),
    mAdjustTime(0.0),
    mPrevTime(nil),
    mStartTime(nil)
{
}

OSXDNTimeKeeperImpl::~OSXDNTimeKeeperImpl()
{
}

bool OSXDNTimeKeeperImpl::setIntevalSec(float time)
{
    mIntervalTime = time;
    mAvgActualInterval = time;
    mAdjustTime = 0.0;
    return true;
}

bool OSXDNTimeKeeperImpl::sleepUntilNextInterval()
{
    if (mStartTime == nil)
    {
        TKLog::printf("Error at DNTimeKeeper::sleepUntilNextInterval. Timer hasn't started yet.");
    }
    NSTimeInterval dt = [mPrevTime timeIntervalSinceNow];
    NSTimeInterval wt = mIntervalTime + dt + mAdjustTime;
    if (wt < 0.005)  // wait at least 5ms.
    {
        wt = 0.005; 
    }
    [NSThread sleepForTimeInterval:wt];
    NSDate *t = [NSDate date];
    mAvgActualInterval = mAvgActualInterval * 0.9 + [t timeIntervalSinceDate:mPrevTime] * 0.1;
    mAdjustTime += (mIntervalTime - mAvgActualInterval);
    mPrevTime = t;

    mTickTime = [mPrevTime timeIntervalSinceDate:mStartTime];
    
    return true;
}

float OSXDNTimeKeeperImpl::getTickTime()
{
    return mTickTime;
}

bool OSXDNTimeKeeperImpl::start()
{
    mStartTime = [NSDate date];
    mPrevTime = mStartTime;
    mAvgActualInterval = mIntervalTime;
    mAdjustTime = 0.0;
    mTickTime = 0.0;
    return true;
}

bool OSXDNTimeKeeperImpl::stop()
{
    mStartTime = nil;
    return true;
}

