//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 2/14/2012.
//

#import <Cocoa/Cocoa.h>

#include "DNHTTPServer.h"

@class SimpleHTTPConnection, SimpleHTTPServer;

@interface SimpleHTTPServerController : NSObject
{
    SimpleHTTPServer *server;
    DNClientRequestHandler requestHandler;
    DNHTTPServer *dnserver;
}
//initialize methods
- (id) initWithTCPPort:(unsigned int)port_number dnserver:(DNHTTPServer*) server requestHandler:(DNClientRequestHandler) handler;

//interface methods
- (void)replyWithStatusCode:(int)code message:(NSString *)message;
- (void)replyWithData:(NSData *)data MIMEType:(NSString *)type;
- (void)stop;

//delegate methods
- (void)processURL:(NSURL *)path body:(NSString*) body connection:(SimpleHTTPConnection *)connection;
- (void)stopProcessing;

@end
