//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 2/25/2012.
//
#include "qtdnalertimpl.h"
#include <QtDebug>
#include <QString>
#include <QMessageBox>

QtDNAlertImpl::QtDNAlertImpl()
{
}

//static
void DNAlertImpl::show(std::string title, std::string message)
{
    qDebug() << QString::fromStdString(title) << "  " << QString::fromStdString(message);
    QMessageBox msgBox;
    msgBox.addButton(QMessageBox::Ok);
    msgBox.setWindowTitle(QString::fromStdString(title));
    msgBox.setText(QString::fromStdString(message));

    msgBox.exec();
}
