//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 1/17/2013.
//
#include "qtdnplugin.h"

#include "DNUtils.h"

#include <QApplication>

QtDNPlugin::QtDNPlugin(QString name) : DNPlugin()
{
#if defined(Q_WS_WIN)
    QString libPath = QApplication::applicationDirPath() + "/plugins/win32/" + name + ".dll";
#elif defined(Q_WS_MAC)
    QString libPath = QApplication::applicationDirPath() + "/plugins/osx/" + name;
#else
    QString libPath = QApplication::applicationDirPath() + "/plugins/linux/" + name;
#endif

    d_library = new QLibrary(libPath);

    if (d_library->load())
    {
        d_initFunction              = (DNPlugin::InitFunction)d_library->resolve("init");
        d_unloadFunction            = (DNPlugin::UnloadFunction) d_library->resolve("unload");
        d_getIsReadyFunction        = (DNPlugin::GetIsReadyFunction) d_library->resolve("getIsReady");
        d_queryPluginValueFunction  = (DNPlugin::QueryPluginValueFunction)d_library->resolve("queryPluginValue");
        d_setValueToPluginFunction  = (DNPlugin::SetValueToPluginFunction)d_library->resolve("setValueToPlugin");

        if (d_initFunction && d_unloadFunction && d_queryPluginValueFunction && d_setValueToPluginFunction)
        {
            d_isValid = init();
        }
    }
    else
    {
        std::string message = std::string("Failed to load plugin file '").append(libPath.toStdString()).append("'\n");
        message.append("Reason:").append(d_library->errorString().toStdString());
        dnNotifyError("Initialization failed", message);
    }
}

QtDNPlugin::~QtDNPlugin()
{
    if (d_library)
    {
        unload();
        delete d_library;
    }
}
