//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Mar-1/2012.
//
#include "qtdnthreadimpl.h"

#include "TKLog.h"

//static
DNThread* DNThreadImpl::createThread(DNThreadFunc threadFunc, void *data)
{
    return new DNThread(new QtDNThreadImpl(threadFunc,data));
}

QtDNThreadImpl::QtDNThreadImpl(DNThreadFunc threadFunc, void *data) : mThreadFunc(threadFunc), mData(data)
{
}

QtDNThreadImpl::~QtDNThreadImpl()
{
    mLock.lock();
    if (isRunning())
    {
        if (!wait(5000))
        {
            TKLog::printf(TKLog::WARNING, "!WARNING! DNThread %p hasn't finished in 5sec. execute terminate to quit  forcedly ", this);
            setTerminationEnabled(true);
            terminate();
        }
    }
    mLock.unlock();
}

bool QtDNThreadImpl::start()
{
    if (isRunning())
        return false;

    QThread::start();

    return true;
}

void QtDNThreadImpl::run()
{
    mThreadFunc(mData);
}

bool QtDNThreadImpl::waitForExit(int timeout)
{
    return wait(timeout);
}
