//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 2/25/2012.
//
#ifndef QTDNTIMEKEEPERIMPL_H
#define QTDNTIMEKEEPERIMPL_H

#include "DNTimeKeeperImpl.h"

#include <QDateTime>

class QtDNTimeKeeperImpl : public DNTimeKeeperImpl
{
public:
    QtDNTimeKeeperImpl();
    ~QtDNTimeKeeperImpl();

    virtual bool    setIntevalSec(float full, float signal, float input, float output);
    virtual int     sleepUntilNextInterval();
    virtual float   getTickTime();

    virtual bool    start();
    virtual bool    stop();

private:
    qint64          getTickTimeMS() const;

    qint64          mFullScanIntervalTime;
    qint64          mSignalScanIntervalTime;
    qint64          mInputScanIntervalTime;
    qint64          mOutputScanIntervalTime;

    qint64          mNextFullScanTime;
    qint64          mNextSignalScanTime;
    qint64          mNextInputScanTime;
    qint64          mNextOutputScanTime;

    qint64          mStartTime;
    qint64          mNextTime;
};

#endif // QTDNTIMEKEEPERIMPL_H
