//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 1/2/2012.
//

#ifndef dennco_ConsoleUIOut_h
#define dennco_ConsoleUIOut_h

#include "TKConsole.h"

#import <Cocoa/Cocoa.h>

@class Controller;

class ConsoleUIOut : public TKConsole
{
public:
    ConsoleUIOut(Controller *c) : mView(0), mController(c) {}
    virtual void vprintf(const char *fmt, va_list arg); 
    virtual void vDebugPrintf(const char *fmt, va_list arg); 
    
    void setTextView(NSTextView *view) {mView = view;}
    void clearAll();

private:
    NSTextView *mView;
    Controller *mController;
    
};

#endif
