//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 12/31/2011.
//

#import <Cocoa/Cocoa.h>

@class Controller;

@interface SourceViewWindowController : NSWindowController
{
    IBOutlet NSTextView     *uiStartupScript;
    IBOutlet NSTextView     *uiCellCode;
    IBOutlet NSTextField    *uiClassName;
    
    IBOutlet NSButton       *closeButton;
    IBOutlet NSButton       *cancelButton;
    IBOutlet NSButton       *editButton;
    IBOutlet NSButton       *saveButton;
    
    NSString                *windowTitle;
    NSString                *startupScript;
    NSString                *cellCode;
    NSString                *className;
    
    Controller              *owner;
    
    bool                    isEditing;
    bool                    _isPenddingSaveAction;
    
    
}
-(id)initWithTitleAndOwner:(NSString*)title owner:(Controller*)_owner;
-(void)updateUIState;

-(IBAction) doCloseAction:(id)sender;
-(IBAction) doCancelAction:(id)sender;
-(IBAction) doEditAction:(id)sender;
-(IBAction) doSaveAction:(id)sender;
-(void)setCellCode:(NSString*)code className:(NSString*)name;
-(void)setStartupScript:(NSString*)code;
-(bool)isPenddingSaveAction;
-(void)saveActionCommitted;
-(NSString*)getStartupScript;
-(NSString*)getCellCode;            


@end
