//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Dec-8, 2012.
//
#include "dceditscriptfolder.h"

#include "dccodeeditorscriptmanager.h"

DCEditScriptFolder::DCEditScriptFolder(QObject *parent) :
    QObject(parent), d_attacher(NULL)
{
}

DCEditScriptFolder::~DCEditScriptFolder()
{
    deattach();
}

void DCEditScriptFolder::attach(DCCell *cell)
{
    deattach();
    if (cell)
        d_attacher = DCCodeEditorScriptManager::createCustomScriptAttacher(this, cell);
}

void DCEditScriptFolder::attach(DCCellCode *cellCode)
{
    deattach();
    if (cellCode)
        d_attacher = DCCodeEditorScriptManager::createCellCodeScriptAttacher(this, cellCode);
}

void DCEditScriptFolder::deattach()
{
    if (d_attacher)
    {
        delete d_attacher;
        d_attacher = NULL;
    }
}

QString DCEditScriptFolder::getCurrentScript(bool forceReload)
{
    if (d_attacher)
    {
        return d_attacher->getCurrentScript(forceReload);
    }
    return "";
}
bool DCEditScriptFolder::getIsModified() const
{
    if (d_attacher)
    {
        return d_attacher->getIsModified();
    }
    return false;
}

bool DCEditScriptFolder::getIsFileModifiedByExternalEditor() const
{
    if (d_attacher)
    {
        return d_attacher->getIsFileModifiedByExternalEditor();
    }
    return false;
}

qint64 DCEditScriptFolder::getLoadedTime() const
{
    if (d_attacher)
    {
        return d_attacher->getLoadedTime();
    }
    return 0;
}

void DCEditScriptFolder::setScript(const QString& newScript)
{
    if (d_attacher)
    {
        d_attacher->setScript(newScript);
    }
}

bool DCEditScriptFolder::saveScript()
{
    if (d_attacher)
    {
        return d_attacher->saveScript();
    }
    return false;
}

void DCEditScriptFolder::callbackScriptChanged()
{
    emit scriptChanged();
}

void DCEditScriptFolder::callbackModificationStatusChanged(bool modified)
{
    emit modificationStatusChanged(modified);
}

void DCEditScriptFolder::callbackFileModifiedByExternalEditor(qint64 notifiedTime)
{
    emit fileModifiedByExternalEditor(notifiedTime);
}
