//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#ifndef DCVCONTENT_H
#define DCVCONTENT_H

class DCContainer;
class DCCreator;
class DCVCPage;

#include <QString>

class DCContent
{
    bool parseSettingFile(const char *contentRoot);
    bool parseContainerFile(const char *containerRoot);

    DCCreator   *d_creator;
    bool        d_valid;
    DCContainer *d_container;
    QString     d_contentRootPath;

public:
    DCContent(DCCreator *creator, std::string contentPath);
    virtual ~DCContent();

    bool            getIsModified() const;
    bool            isValid() const { return d_valid; }

    DCContainer*    getContainer() const { return d_container; }
    DCCreator*      getCreator() const { return d_creator; }
    QString         getContentRootPath() const { return d_contentRootPath; }

    bool            saveAll(const QString& contentRoot);
    bool            saveForPage(const QString& contentRoot, DCVCPage *page);

};

#endif // DCVCONTENT_H
