//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#ifndef DCADDCELLCODECLASSDIALOG_H
#define DCADDCELLCODECLASSDIALOG_H

#include <QDialog>
#include <QTableView>
#include <QComboBox>
#include <QLabel>
#include <QUndoCommand>

class DCContainer;
class DCCreator;
class DCQtItemModel;
class DCSingleColumnTableView;

class DCAddCellCodeClassDialog : public QDialog
{
    Q_OBJECT

private:
    DCContainer                 *d_container;
    DCCreator                   *d_creator;
    DCSingleColumnTableView     *d_table;
    DCQtItemModel               *d_tableModel;
    QComboBox                   *d_comboBox;
    QPushButton                 *d_okButton;
    QPushButton                 *d_cancelButton;
    QString                     d_selectedPagePath;
    QLineEdit                   *d_textField;
    QLabel                      *d_statusText;
    QLabel                      *d_message;

    bool            checkInput();

public:
    DCAddCellCodeClassDialog(DCCreator *creator, const QString& path, QWidget *parent = 0);
    virtual ~DCAddCellCodeClassDialog();

    QString getAddedCellCodeClassName() const;
    
signals:
    
private slots:
    void textInputChanged(const QString &text);
    void okButtonClicked();
    void cancelButtonClicked();
    void listSelectionChanged(const QItemSelection &selected, const QItemSelection &deselected);
    void commandExecuted(const QUndoCommand* executedCommand);
};

#endif // DCADDCELLCODECLASSDIALOG_H
