//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Dec-19, 2012.
//
#include "dccodeeditorexternaleditorsettingdialog.h"

#include <QFileDialog>
#include <QVBoxLayout>
#include <QLabel>
#include <QTextLine>
#include <QGroupBox>

#include "mainwindow.h"

DCCodeEditorExternalEditorSettingDialog::DCCodeEditorExternalEditorSettingDialog(QWidget *parent) :
    QDialog(parent), d_ok(false)
{
    setWindowTitle(tr("Choose external editor"));
    QString instruction =
            "<br><p>Executable:<ul><li>set the file path for the external editor.</li></ul></p>"
            "<p>Parameter: <ul><li>Set the parameters to pass to the executable file.<br>"
            "%F will be replaced to the file name of the script file to edit. </li></ul></p><br>";

    QLabel *instructionLabel = new QLabel;
    instructionLabel->setTextFormat(Qt::RichText);
    instructionLabel->setWordWrap(true);
    instructionLabel->setFrameStyle(QFrame::Box);
    instructionLabel->setLineWidth(1);
    instructionLabel->setText(instruction);
    QGridLayout *gridLayout = new QGridLayout;
    d_executableText = new QLineEdit;
    d_chooseFileButton = new QPushButton(tr("Choose..."));
    gridLayout->addWidget(new QLabel(tr("Executable:")), 0,0);
    gridLayout->addWidget(d_executableText, 0,1);
    gridLayout->addWidget(d_chooseFileButton, 0, 2);

    d_parameterText = new QLineEdit;
    gridLayout->addWidget(new QLabel(tr("Parameter:")), 1,0);
    gridLayout->addWidget(d_parameterText, 1,1,1,2);

    d_okButton = new QPushButton(tr("OK"));
    d_cancelButton = new QPushButton(tr("Cancel"));
    QHBoxLayout *buttonLayout = new QHBoxLayout;
    buttonLayout->addStretch();
    buttonLayout->addWidget(d_okButton);
    buttonLayout->addWidget(d_cancelButton);

    QVBoxLayout *layoutBase = new QVBoxLayout;
    layoutBase->addWidget(instructionLabel);
    layoutBase->addLayout(gridLayout);
    layoutBase->addLayout(buttonLayout);

    setLayout(layoutBase);

    d_executableText->setText(MainWindow::readSettingsForExternalScriptEditorPath());
    QString parameter = MainWindow::readSettingsForExternalScriptEditorParameters();
    if (parameter.isEmpty() || parameter.length() == 0)
    {
        parameter = "\"%F\"";
    }
    d_parameterText->setText(parameter);

    connect(d_chooseFileButton, SIGNAL(clicked()), this, SLOT(chooseFileButtonPressed()));
    connect(d_okButton, SIGNAL(clicked()), this, SLOT(okButtonPressed()));
    connect(d_cancelButton, SIGNAL(clicked()), this, SLOT(cancelButtonPressed()));
}

DCCodeEditorExternalEditorSettingDialog::~DCCodeEditorExternalEditorSettingDialog()
{

}

bool DCCodeEditorExternalEditorSettingDialog::getResult() const
{
    return d_ok;
}

void DCCodeEditorExternalEditorSettingDialog::chooseFileButtonPressed()
{
    QFileDialog dialog(this, tr("Choose editor"), d_executableText->text());
    dialog.setAcceptMode(QFileDialog::AcceptOpen);
    dialog.setFileMode(QFileDialog::ExistingFile);
    if (dialog.exec())
    {
        d_executableText->setText(dialog.selectedFiles().at(0));
    }
}

void DCCodeEditorExternalEditorSettingDialog::okButtonPressed()
{
    MainWindow::writeSettingsForExternalScriptEditorPath(d_executableText->text());
    MainWindow::writeSettingsForExternalScriptEditorParameters(d_parameterText->text());
    d_ok = true;
    close();
}

void DCCodeEditorExternalEditorSettingDialog::cancelButtonPressed()
{
    close();
}
