//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Oct-20, 2012.
//
#ifndef DCUIEDITOR_H
#define DCUIEDITOR_H

#include <QDialog>
#include <QTabWidget>
#include <QWebView>
#include <QPushButton>

class DCUITextEditor;

class DCUIJSInterface : public QObject
{
    Q_OBJECT
public:
    DCUIJSInterface();
    virtual ~DCUIJSInterface();

signals:

public slots:
    void    setValue(const QString name, float value);
    float   getValue(const QString name) const;
};

class DCUIEditor : public QDialog
{
    Q_OBJECT

    QTabWidget      *d_tabWidget;
    QWebView        *d_webView;
    DCUITextEditor  *d_textEditor;
    QString         d_originalSource;

    QString         d_editingFile;
    bool            d_isEditing;
    bool            d_isInInitialization;
    bool            d_isChangeMade;
    QObject         *d_jsInterface;

    QPushButton     *d_saveButton;
    QPushButton     *d_closeButton;

    bool            getIsModified() const;
    bool            maybeSave();

    void            updateWindowTitle(bool fileModified);
public:
    explicit DCUIEditor(QWidget *parent = 0);

    static DCUIEditor* getEditor();
    static void destroyEditor();

    virtual void closeEvent(QCloseEvent *event);

    bool startEditing(const QString& sysFilePath);

signals:
    
private slots:
    bool saveChange();
    void javaScriptWindowObjectCleared();
    void tabChanged(int index);
    void textChanged();
};

#endif // DCUIEDITOR_H
