//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#ifndef DCTOOLWINDOWCELLEDITOR_H
#define DCTOOLWINDOWCELLEDITOR_H

#include "dctoolwindowbase.h"

#include <QtGui>

class DCCell;
class DCEditableTreeView;
class DCQtItemModel;
class DCEditableLabel;
class DCCellTypeComboBox;

class DCToolWindowCellEditor : public DCToolWindowBase
{
    Q_OBJECT
private:
    DCCell              *d_cell;
    DCEditableLabel     *d_textPage;
    DCCellTypeComboBox  *d_comboType;
    QPushButton         *d_classButton;
    QPushButton         *d_customScriptButton;
    QPushButton         *d_detailButton;
    DCEditableTreeView  *d_receptors;
    DCQtItemModel       *d_receptorItemModel;
    DCEditableTreeView  *d_axonTerminals;
    DCQtItemModel       *d_axonTerminalItemModel;
    QGridLayout         *d_layout;
    bool                d_isViewUpdating;

    void                resizeView();

public:
    explicit DCToolWindowCellEditor(DCCreator *creator);
    virtual ~DCToolWindowCellEditor();

    virtual int getPosPriority() const { return 2; }
    DCCell*     getCell() const { return d_cell; }
    bool        getIsViewUpdating() const { return d_isViewUpdating; }

    void        setCell(DCCell *cell);

    void        updateView();

private slots:
    void    slotAxonTerminalTreeExpanded(const QModelIndex &index);
    void    slotAxonTerminalTreeCollapsed(const QModelIndex &index);
    void    slotAxonTerminalItemClicked(const QModelIndex &index);
    void    slotReceptorTreeExpanded(const QModelIndex &index);
    void    slotReceptorTreeCollapsed(const QModelIndex &index);
    void    slotReceptorItemClicked(const QModelIndex &index);
    void    adjustTreeColumnWidth();

    void    slotCellCodeEditButtonPressed();
    void    slotCustomScriptEditButtonPressed();

    void    slotCellDestroyed();

};

#endif // DCTOOLWINDOWCELLEDITOR_H
