//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Nov-3, 2012.
//
#ifndef DCCELLSCRIPTSEDITORWINDOW_H
#define DCCELLSCRIPTSEDITORWINDOW_H

#include <QDialog>
#include <QPushButton>
#include <QTabWidget>
#include <QLabel>
#include <QLineEdit>
#include <QStackedLayout>
#include <QMap>
#include <QUndoCommand>

class DCCreator;
class DCScene;
class DCCell;
class DCCellCode;
class DCVCPage;
class DCCodeEditor;
class DCCellScriptsEditorTabWidget;

class DCCellScriptsEditorWindow : public QDialog
{
    Q_OBJECT

    DCCreator                       *d_creator;

    DCCellScriptsEditorTabWidget    *d_tabWidget;
    DCCodeEditor                    *d_customScriptEditor;
    DCCodeEditor                    *d_classCodeEditor;

    QPushButton                     *d_saveButton;
    QPushButton                     *d_closeButton;

    QLineEdit                       *d_cellName;
    QLineEdit                       *d_cellPath;
    QLineEdit                       *d_cellType;
    QLineEdit                       *d_cellCodeName;
    QLineEdit                       *d_cellCodePath;
    QPushButton                     *d_assignCellCodeButton;
    QPushButton                     *d_unassignCellCodeButton;
    QStackedLayout                  *d_cellCodePanel;

    bool maybeSave();
    bool maybeSave(DCCell *cell);
    bool maybeSave(int index);
    void updateWindowState();
    bool startEditingPrivate(DCCell *cell, bool focusInCellCodeScriptFirst);
    bool saveScriptsBelongToPrivate(DCVCPage *page, bool modifiedOnly);
    QSet<DCVCPage*> saveScriptsAllPrivate(bool modifiedOnly);

    DCCellScriptsEditorWindow(DCCreator *creator, QWidget *parent = 0);
public:
    virtual ~DCCellScriptsEditorWindow();

    static DCCellScriptsEditorWindow* construct(DCCreator *creator);
    static bool getIsVisible();
    static bool startEditing(DCCell *cell, bool focusInCellCodeScriptFirst = true);
    static bool saveScriptsBelongTo(DCVCPage *page, bool modifiedOnly);
    static QSet<DCVCPage*> saveScriptsAll(bool modifiedOnly);
    static bool closeEditor();
    static void destroyEditor();

    virtual void closeEvent(QCloseEvent *event);


signals:

private slots:
    void sceneChanged(const void *requester, DCScene *scene);
    void editTabChanged(DCCell *cell);
    void editTabContentModifiedStatusChanged(DCCell *cell, bool);
    void editTabRemoved(DCCell *cell);
    void editTabCloseRequested(DCCell *cell);
    void saveButtonClicked();
    void creatorCommandExecuted(const QUndoCommand *command);
    void assignCellCode();
    void unassignCellCode();
};

#endif // DCCELLSCRIPTSEDITORWINDOW_H
