//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#ifndef DCCOMMAND_H
#define DCCOMMAND_H

#include <QUndoCommand>

class DCCreator;
class DCContainer;
class DCScene;

class DCCommand : public QUndoCommand
{
public:
    enum E_DCCOMMAND_RESULT {DCCOMMAND_NOT_EXECUTED, DCCOMMAND_SUCCEEDED, DCCOMMAND_FAILED };

private:
    const void          *d_requester;
    DCCreator           *d_controller;
    DCContainer         *d_container;
    DCScene             *d_scene;
    E_DCCOMMAND_RESULT  d_commandResult;

public:
    DCCommand(const void *requester, DCCreator *creator);
    virtual ~DCCommand() {}

    const void *        getRequester() const { return d_requester; }
    DCCreator *         getController() const { return d_controller; }
    DCContainer *       getContainer() const { return d_container; }
    DCScene *           getScene() const { return d_scene; }
    E_DCCOMMAND_RESULT  getCommandResult() const { return d_commandResult; }

protected:
    void                setCommandResult(E_DCCOMMAND_RESULT result) { d_commandResult = result; }
};

#endif // DCCOMMAND_H
