//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#ifndef DCRECEPTOR_H
#define DCRECEPTOR_H

#include "TKReceptor.h"

class DCCell;
class DCVCReceptor;
class DCVComponent;
class DCVCEditModeCursor;
class DCAxonTerminal;

class DCReceptor : public TKReceptor
{
    friend struct DCComponentUtil;
    DCReceptor(DCCell *theOwner);
    void bindComponent(DCVComponent *component) { d_vComponent = component; }

    DCVComponent        *d_vComponent;
    bool                d_isTerminalVisible;
    DCVCEditModeCursor  *d_editCursor;

public:
    virtual ~DCReceptor();

    DCAxonTerminal*     getTarget() const;
    DCCell*             getOwnerCell() const;
    DCVComponent*       getVComponent() const;
    void                getViewReceptorOffsetPoint(float dx, float dy, float dz,float *x, float *y, float *z) const;
    bool                getIsTerminalVisible() const { return d_isTerminalVisible; }
    bool                hasEditCursor() const { return d_editCursor != 0; }
    DCVCEditModeCursor* getEditCursor() const { return d_editCursor; }

    void                setTerminalVisible(bool visible) { d_isTerminalVisible = visible; }
    void                setEditingCursorViewMatrix(const float matrix[]);

    void                registerEditCursor(DCVCEditModeCursor *cursor);
    void                unregisterEditCursor();

};

#endif // DCRECEPTOR_H
