//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#include "dcinputnewpagenamedialog.h"

#include <QVBoxLayout>
#include <QLabel>
#include <QFileInfo>

DCInputNewPageNameDialog::DCInputNewPageNameDialog(const QString &sysDir, const QString &windowTitle, const QString &fileName, QWidget *parent)
    : QDialog(parent), d_dir(sysDir), d_result("")
{
    setWindowTitle(windowTitle);

    d_inputField = new QLineEdit(fileName);
    QVBoxLayout *contentLayout = new QVBoxLayout;
    contentLayout->addWidget(new QLabel(tr("name")));
    QHBoxLayout *hlayout = new QHBoxLayout;
    hlayout->addWidget(d_inputField);
    hlayout->addWidget(new QLabel(tr(".xhtml")));
    QHBoxLayout *buttonLayout = new QHBoxLayout;
    d_cancelButton = new QPushButton(tr("Cancel"));
    d_okButton = new QPushButton(tr("OK"));
    d_okButton->setEnabled(false);
    buttonLayout->addWidget(d_cancelButton);
    buttonLayout->addWidget(d_okButton);

    contentLayout->addLayout(hlayout);
    contentLayout->addLayout(buttonLayout);

    setLayout(contentLayout);

    connect(d_okButton, SIGNAL(clicked()), this, SLOT(okButtonClicked()));
    connect(d_cancelButton, SIGNAL(clicked()), this, SLOT(cancelButtonClicked()));
    connect(d_inputField, SIGNAL(textChanged(QString)), this, SLOT(inputChanged()));
}

void DCInputNewPageNameDialog::inputChanged()
{
    if (d_inputField->text().length() > 0)
    {
        QFileInfo fileInfo(d_dir + "/" + d_inputField->text() + ".xhtml");
        if (!fileInfo.exists())
        {
            d_okButton->setEnabled(true);
            d_okButton->setDefault(true);
        }
        else
        {
            d_okButton->setEnabled(false);
            d_cancelButton->setDefault(true);
        }
    }
    else
    {
        d_okButton->setEnabled(false);
        d_cancelButton->setDefault(true);
    }
}

void DCInputNewPageNameDialog::okButtonClicked()
{
    d_result = d_inputField->text();
    done(true);
}

void DCInputNewPageNameDialog::cancelButtonClicked()
{
    d_result = "";
    done(false);
}
