//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Mar-1/2012.
//
#include "DNGlobal.h"

DNGlobal* dnGlobal()
{
    return DNGlobal::instance();
}

//static
DNGlobal *DNGlobal::instance()
{
    static DNGlobal *_instance = 0;
    if (!_instance)
    {
        _instance = new DNGlobal();
    }

    return _instance;
}

DNGlobal::DNGlobal() : mEStatus(NORMAL), mRStatus(STOPPED)
{
}

DNGlobal::~DNGlobal()
{
}

bool DNGlobal::updateErrorStatus(E_Status status)
{
    bool isStatusUpdated = false;
    mLock.lock();
    if (mEStatus < status)
    {
        mEStatus = status;
        isStatusUpdated = true;
    }
    mLock.unlock();
    return isStatusUpdated;
}

void DNGlobal::setMessage1(std::string message1)
{
    mLock.lock();
    mMessage1 = message1;
    mLock.unlock();
}

void DNGlobal::setMessage2(std::string message2)
{
    mLock.lock();
    mMessage2 = message2;
    mLock.unlock();
}

DNGlobal::E_Status DNGlobal::getErrorStatus()
{
    return mEStatus;
}

bool DNGlobal::isErrorStatusNormal()
{
    return mEStatus == NORMAL;
}

std::string DNGlobal::getMessage1()
{
    if (mEStatus > NORMAL)
    {
        return mMessage1;
    }
    else
    {
        return "";
    }
}

std::string DNGlobal::getMessage2()
{
    if (mEStatus > NORMAL)
    {
        return mMessage2;
    }
    else
    {
        return "";
    }
}

void DNGlobal::resetErrorStatus()
{
    mEStatus = NORMAL;
    mMessage1 = "";
    mMessage2 = "";
}

DNGlobal::R_Status DNGlobal::getRunningStatus()
{
    return mRStatus;
}

bool DNGlobal::updateRunningStatus(R_Status status)
{
    bool updated = false;
    mLock.lock();
    if (mRStatus != status)
    {
        updated = true;
        mRStatus = status;
    }
    mLock.unlock();

    return updated;
}
