//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Mar-1/2012.
//
#ifndef DNGLOBAL_H
#define DNGLOBAL_H

#include <string>
#include "TKLock.h"

class DNGlobal
{
public:
    static DNGlobal* instance();
    ~DNGlobal();

    enum        E_Status {NORMAL,WARNING,ERROR,FATAL_ERROR};
    enum        R_Status {STOPPED,RUNNIING,STOPPING};

    bool        updateErrorStatus(E_Status status);
    E_Status    getErrorStatus();

    bool        isErrorStatusNormal();
    void        setMessage1(std::string message);
    void        setMessage2(std::string message);
    std::string getMessage1();
    std::string getMessage2();
    void        resetErrorStatus();

    bool        updateRunningStatus(R_Status running);
    R_Status    getRunningStatus();


private:
    DNGlobal();
    TKLock      mLock;
    std::string mMessage1;
    std::string mMessage2;
    E_Status    mEStatus;
    R_Status    mRStatus;
};

DNGlobal* dnGlobal();

#endif // DNGLOBAL_H
