//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 1/7/2012.
//

#include "DNXMLElement.h"

DNXMLElement::DNXMLElement(std::string _name):
outer(NULL),inner(NULL),next(NULL),depth(0),name(_name),text("")
{
}

DNXMLElement::~DNXMLElement()
{
    DNXMLElement *e = inner;
    while (e && e != this && depth <= e->depth)
    {
        while(e->inner) e = e->inner;
        if (e->outer)
            e->outer->inner = e->next;
        DNXMLElement *ne = e->next ? e->next : e->outer;
        delete e;
        e = ne;
    }
    mAttributes.clear();
}

void DNXMLElement::setAttribute(const char *name, const char *value)
{
    std::string _key = name;
    std::string _value = value;
    mAttributes.insert(std::map<std::string, std::string>::value_type( _key, _value));
}

void DNXMLElement::setAttribute(std::string name, std::string value)
{
    mAttributes.insert(std::map<std::string, std::string>::value_type( name, value));
}

std::string DNXMLElement::getAttributeValue(const char *name)
{
    std::string key = name;
    std::map<std::string, std::string>::iterator it = mAttributes.find(key);
    if (it != mAttributes.end())
    {
        return it->second;
    }
    else
    {
        return "";
    }
}
