//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 2/25/2012.
//
#ifndef QTDNXMLIMPL_H
#define QTDNXMLIMPL_H

#include "DNXMLImpl.h"
#include <QXmlDefaultHandler>

class QtXMLHandler : public QXmlDefaultHandler
{
public:
    QtXMLHandler(QString filePath);
    virtual ~QtXMLHandler();

    DNXMLElement *getRoot() { return mRootElement; }

    //QXML handler implementation
    virtual bool startDocument();
    virtual bool endDocument();
    virtual bool startElement(const QString & namespaceURI, const QString & localName, const QString & qName, const QXmlAttributes & atts );
    virtual bool endElement (const QString & namespaceURI, const QString & localName, const QString & qName );
    virtual bool characters (const QString & ch );
    virtual bool error (const QXmlParseException & exception );
    virtual bool fatalError(const QXmlParseException & exception );

private:
    DNXMLElement    *mRootElement;
    DNXMLElement    *mCurrentElement;
    QString         mFilePath;

};

class QtDNXMLImpl : public DNXMLImpl
{
public:
    QtDNXMLImpl(QString filePath);
    virtual ~QtDNXMLImpl();
    virtual DNXMLElement *getRoot();

private:
    QtXMLHandler    *mHandler;
    bool            mValid;
    QString         mFilePath;
};


#endif // QTDNXMLIMPL_H
