//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QProcess>
#include <QSharedMemory>

namespace Ui {
class MainWindow;
}

class DCCreator;
class DCGLVisualizerWidget;
class DCTreeViewWidget;
class DCCellCodeScriptTreeViewWidget;

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

    static QByteArray readSettingsForCellScriptsEditorGeometory();
    static void writeSettingsForCellScriptsEditorGeometory(const QByteArray &value);
    static QString readSettingsForExternalScriptEditorPath();
    static QString readSettingsForExternalScriptEditorParameters();
    static void writeSettingsForExternalScriptEditorPath(const QString& arg);
    static void writeSettingsForExternalScriptEditorParameters(const QString& arg);
    static bool openExternalEditorFor(const QString& path);

protected:
    void closeEvent(QCloseEvent *event);

private slots:
    void newFile();
    void open();
    void openRecent1();
    void openRecent2();
    void openRecent3();
    void openRecent4();
    void openRecent5();
    bool save();
    bool save(bool showMessage);
    bool saveAs();
    void doExternalEditorSetting();
    void about();
    void documentWasModified();
    void playContent();
    void manageCellCode();

private:
    void createActions();
    void createMenus();
    void createOpenRecentMenu();
    void createToolBars();
    void createStatusBar();
    void readSettings();
    void writeSettings();
    bool maybeSave();
    bool openRecent(int idx);
    void loadContent(const QString &contentDirectory);
    void setCurrentContent(const QString &contentDirectory);
    QString strippedName(const QString &fullFileName);

    QString curContent;

    QMenu *fileMenu;
    QMenu *openRecentMenu;
    QMenu *editMenu;
    QMenu *helpMenu;
    QMenu *settingMenu;
    QToolBar *fileToolBar;
    QToolBar *editToolBar;
    QToolBar *playToolBar;
    QAction *newAct;
    QAction *openAct;
    QAction *saveAct;
    QAction *saveAsAct;
    QAction *exitAct;
    QAction *manageCellCodeAct;
    QAction *cutAct;
    QAction *copyAct;
    QAction *playAct;
    QAction *pasteAct;
    QAction *externalEditorSettingAct;
    QAction *aboutAct;
    QList<QAction*> openRecentActs;

    Ui::MainWindow *ui;

    DCCreator                       *d_creator;
    DCGLVisualizerWidget            *d_visualizerWidget;
    DCTreeViewWidget                *d_treeViewWidget;
    DCCellCodeScriptTreeViewWidget  *d_cellCodeScriptTreeViewWidget;
    QProcess                        d_player;
    QString                         d_IPCServerName;
    QStringList                     d_contentOpenHistory;
};

#endif // MAINWINDOW_H
