//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#ifndef DCTREEVIEWWIDGET_H
#define DCTREEVIEWWIDGET_H

#include <QTreeView>
#include <QShowEvent>
#include <QFileSystemModel>
#include <QUndoCommand>

class DCCreator;
class DCScene;

class DCTreeViewModel : public QFileSystemModel
{
    Q_OBJECT
private:
    DCCreator           *d_creator;

public:
    DCTreeViewModel(DCCreator *creator);
    virtual ~DCTreeViewModel();

    virtual bool setData(const QModelIndex &index, const QVariant &value, int role);

};

class DCTreeViewWidget : public QTreeView
{
    Q_OBJECT
private:
    DCCreator           *d_creator;
    DCTreeViewModel     d_fileSystemModel;
    DCScene             *d_scene;
    bool                d_inSelectionChange;
    QString             d_pendingSelectionPath;

public:
    DCTreeViewWidget(QWidget *parent, DCCreator *creator);
    virtual ~DCTreeViewWidget();

    static bool addDirectory(const QString &path);
    static bool removeDirectory(const QString &path);
    static bool removeFile(const QString &path);
    static void selectWhenFilePathAdded(const QString &path);

protected:
    virtual void showEvent(QShowEvent *);
    virtual void mouseDoubleClickEvent(QMouseEvent *event);
    virtual void rowsInserted(const QModelIndex &parent, int start, int end);

private slots:
    void directoryLoaded(const QString &directory );
    void contentRootPathChanged(const void *requester, QString rootPath);
    void sceneChanged(const void *requester, DCScene*scene);
    void selectedPageChanged(const void *requester, const DCScene*scene);
    void creatorDestroyed();
    void rowsRemoved();

    virtual void selectionChanged(const QItemSelection &selected, const QItemSelection &deselected);

    void doContextMenu(const QPoint &pos);

    void commandExecuted(const QUndoCommand *command);
};

#endif // DCTREEVIEWWIDGET_H
