//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#ifndef DCCOMMANDUTIL_H
#define DCCOMMANDUTIL_H

class DCCommand;
class DCCreator;
class DCContainer;
class DCCell;
class DCCellCode;
class DCAxon;
class DCReceptor;
class DCAxonTerminal;
class DCVCPage;

#include <QString>

struct DCCommandUtil
{
    static void postStartAddAxonTerminalCommandFromAxon(const void *requester, DCCreator *creator, DCCell *ownerCell);
    static void postStartAddAxonTerminalCommandFromReceptor(const void *requester, DCCreator *creator, DCCell *ownerCell, const QString &receptorName);
    static void postCommitAddAxonTerminalCommand(const void *requester, DCCreator *creator, DCAxon *axon, DCCell *receptorCell, const QString &receptorName);
    static void postCommitAddAxonTerminalCommand(const void *requester, DCCreator *creator, DCCell *axonCell, DCReceptor *receptor);
    static void postRemoveAxonTerminalCommand(const void *requester, DCCreator *creator, DCCell *axonCell, DCAxonTerminal *axonTerminal);
    static void postRemoveAxonTerminalCommand(const void *requester, DCCreator *creator, DCCell *receptorCell, const QString& receptorName);

    static void postUndoRequestCommand(const void *requester, DCCreator *creator);

    static void postAssignCellCodeClassToCellCommand(const void *requester,  DCCreator *creator, DCCell *cell, DCCellCode *cellCode);
    static void postUnassignCellCodeClassFromCellCommand(const void *requester,  DCCreator *creator, DCCell *cell);

    static void postAddCellCodeClassCommand(const void *requester, DCCreator *creator, DCContainer *container, const QString& name, const QString& type);
    static void postChangeCellCodeClassTypeCommand(const void *requester, DCCreator *creator, DCCellCode *cellCode, const QString& newType);
    static void postAddCellCommand(const void *requester, DCCreator *creator, DCContainer *container, const QString& containerBasedPath, const QString& name, const QString& type, float pageX, float pageY);
    static void postRenameCellCommand(const void *requester, DCCreator *creator, DCCell *cell, const QString& newContainerBasedPath, const QString& newName);
    static void postChangeCellTypeCommand(const void* requester, DCCreator *creator, DCCell *cell, const QString& newType);
    static void postRemoveCellCommand(const void *requester, DCCreator *creator, DCContainer *container, DCCell *cells);
    static void postRemoveCellCodeCommand(const void *requester, DCCreator *creator, DCContainer *container, DCCellCode *cells);
    static void postRemoveCellsCommand(const void *requester, DCCreator *creator, DCContainer *container, const QList<DCCell*> &cells);
    static void postAddPageCommand(const void *requester, DCCreator *creator, const QString& containerBasedPath);
    static void postMovePageCommand(const void *requester, DCCreator *creator, const QString &oldContainerBasedPath, const QString& newContainerBasedPath);
    static void postRemovePageCommand(const void *requester, DCCreator *creator, DCVCPage *page);

    static void postAddDirectoryCommand(const void *requester, DCCreator *creator, const QString& sysFilePath);
    static void postRenameDirectoryCommand(const void *requester, DCCreator *creator, const QString& sysOldFilePath, const QString& sysNewFilePath);
    static void postRemoveDirectoryCommand(const void *requester, DCCreator *creator, const QString& sysFilePath);

    static void postRenameReceptorNameCommand(const void *requester, DCCreator *creator, DCCell *cell, const QString& oldName, const QString& newName);

    static DCCommand* createRenameReceptorNameCommand(const void *requester, DCCreator *creator, DCCell *cell, const QString& oldName, const QString& newName);

};

#endif // DCCOMMANDUTIL_H
