//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#ifndef DCVCCELL_H
#define DCVCCELL_H

#include "dcvpagecomponent.h"

class DCCell;
class TKCellCode;
class DCCubeRenderer;
class DCSelectionRenderer;
class DCVCPage;

class DCVCCell : public DCVPageComponent
{
    DCCell              *d_owner;
    DCCubeRenderer      *d_shape;
    bool                d_shouldUpdateShape;
    DCSelectionRenderer *d_selectionRectRenderer;
    float               d_dragOffsetX;
    float               d_dragOffsetY;
    float               d_dragOffsetZ;
    float               d_draggingOriginalSize;
    bool                d_isDragging;
    bool                d_isResizingDrag;
    float               d_draggingOriginalAxonLength;
    TKCellCode          *d_emptyCellCode;

public:
    DCVCCell(DCCell *owner, DCVCPage *page, float size, float height);
    virtual ~DCVCCell();


    virtual DCCell*     getOwnerCell() const { return d_owner; }
    virtual bool        isResizingArea(float x, float y, float z) const;

    /**
     * @brief Change page this cell belongs.
     * @param page
     * @note DCVCPage will call this.
     * Other classes shouldn't directly call this method.
     * To move cell to other page, DCMoveCellCommand should be used.
     */
    virtual void    changePageBelonging(DCVCPage *page);

    virtual void    prepareChildrenForDraw(bool isAnimationInterval);
    virtual void    drawChildren(bool isAnimationInterval);
    virtual void    drawChildrenForSelection(QList<DCVComponent*> *itemList);
    virtual void    translate();
    virtual void    setSelected(bool selected, bool updateChildren);
    virtual void    setVisible(DCVVisibility visible, DCVVisibility visibleChildren);
    virtual void    setSelectable(bool selectable);
    virtual void    renderOwnShape(bool isAnimationInterval, bool renderAsWireframe);
    virtual void    updateShape();

    virtual bool    startDrag(float x, float y, float z, bool isResizingDrag);
    virtual bool    dragging(float x, float y, float z, bool isResizingDrag);
    virtual bool    endDrag(float x, float y, float z, bool isResizingDrag);

    virtual void    saveAttributesToXML(QDomDocument *document, QDomElement* element) const;
    virtual void    loadAttributesFromXML(QDomElement element);

    void    addReceptor();
};

#endif // DCVCCELL_H
