//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#ifndef DCVCCELLCODE_H
#define DCVCCELLCODE_H

#include "dcvpagecomponent.h"

class DCCellCode;

class DCVCCellCode : public DCVPageComponent
{
    DCCellCode *d_owner;

public:
    DCVCCellCode(DCCellCode *owner, DCVCPage *page);

    virtual DCCell *    getOwnerCell() const { return NULL; }
    virtual bool        isResizingArea(float x, float y, float z) const { (void)x; (void)y; (void)z; return false; }

    /**
     * @brief Change page this cell code belongs.
     * @param page
     * @note DCVCPage will call this.
     * Other classes shouldn't directly call this method.
     * To move cell to other page, DCMoveCellCodeClassCommand should be used.
     */
    DCCellCode*     getOwnerCellCodeClass() const { return d_owner; }
    virtual void    changePageBelonging(DCVCPage *page);
    virtual void    prepareChildrenForDraw(bool isAnimationInterval) { (void)isAnimationInterval; }
    virtual void    drawChildren(bool isAnimationInterval) { (void)isAnimationInterval; }
    virtual void    drawChildrenForSelection(QList<DCVComponent*> *itemList) { (void)itemList; }
    virtual void    translate() {}
    virtual void    renderOwnShape(bool isAnimationInterval, bool renderAsWireframe) { (void)isAnimationInterval; (void)renderAsWireframe; }
    virtual void    updateShape() {}

    virtual bool    startDrag(float x, float y, float z, bool isResizingDrag){ (void)x; (void)y; (void)z; (void)isResizingDrag; return false;}
    virtual bool    dragging(float x, float y, float z, bool isResizingDrag){ (void)x; (void)y; (void)z; (void)isResizingDrag;  return false;}
    virtual bool    endDrag(float x, float y, float z, bool isResizingDrag){(void)x; (void)y; (void)z; (void)isResizingDrag;  return false; }

    virtual void    saveAttributesToXML(QDomDocument *document, QDomElement* element) const { (void)document; (void)element; }
    virtual void    loadAttributesFromXML(QDomElement element) { (void)element; }

};

#endif // DCVCCELLCODE_H
