//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#ifndef DCVEVENTHANDLER_H
#define DCVEVENTHANDLER_H

class DCScene;
class DCCreator;
class DCUIGraphicsScene;

#include <QtGui>

class DCVEventHandler
{
    DCUIGraphicsScene   *d_widget;
    DCCreator           *d_creator;
    DCScene             *d_scene;

public:
    DCVEventHandler(DCUIGraphicsScene *widget, DCCreator *creator, DCScene *scene);
    virtual ~DCVEventHandler() {}

    inline DCUIGraphicsScene    *getView() const { return d_widget; }
    inline DCScene              *getScene() const { return d_scene; }
    inline DCCreator            *getController() const { return d_creator; }

    virtual int  getHandlerType() const = 0;
    virtual void mousePressEvent(QGraphicsSceneMouseEvent *event) = 0;
    virtual void mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event) = 0;
    virtual void mouseMoveEvent(QGraphicsSceneMouseEvent *event, int clickTimeElapsed) = 0;
    virtual void mouseReleaseEvent(QGraphicsSceneMouseEvent *event, bool wasDrag) = 0;
    virtual void wheelEvent(QGraphicsSceneWheelEvent  *event) = 0;
    virtual void keyPressEvent(QKeyEvent *event) = 0;
    virtual void keyReleaseEvent(QKeyEvent *event) = 0;
    virtual void showContextMenu(const QPoint &pos) = 0;
    virtual void selectedPageChanged(const void *requester) = 0;
};

#endif // DCVEVENTHANDLER_H
