//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#ifndef DCVTERMINALFROMRECEPTORHANDLER_H
#define DCVTERMINALFROMRECEPTORHANDLER_H

#include "dcveventhandler.h"
#include "dcvpagecomponent.h"

class DCReceptor;
class DCVCEditModeCursor;

class DCVTerminalFromReceptorModeHandler : public DCVEventHandler
{
    DCVCRefHolder       d_draggedObject;
    bool                d_inResigingDrag;
    DCReceptor          *d_editReceptor;
    DCVCEditModeCursor  *d_cursor;

public:
    DCVTerminalFromReceptorModeHandler(DCUIGraphicsScene *widget, DCCreator *creator, DCScene *scene, DCReceptor *editReceptor, DCVCEditModeCursor *cursor);
    virtual ~DCVTerminalFromReceptorModeHandler();

    virtual int  getHandlerType() const;
    virtual void mousePressEvent(QGraphicsSceneMouseEvent *event) ;
    virtual void mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event) ;
    virtual void mouseMoveEvent(QGraphicsSceneMouseEvent *event, int clickTimeElapsed) ;
    virtual void mouseReleaseEvent(QGraphicsSceneMouseEvent *event, bool wasDrag) ;
    virtual void wheelEvent(QGraphicsSceneWheelEvent  *event) ;
    virtual void keyPressEvent(QKeyEvent *event) ;
    virtual void keyReleaseEvent(QKeyEvent *event) ;
    virtual void showContextMenu(const QPoint &pos);
    virtual void selectedPageChanged(const void *requester);
};
#endif // DCVTERMINALFROMRECEPTORHANDLER_H
