//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#ifndef DCTOOLWINDOWTERMINALFROMRECEPTOREDITOR_H
#define DCTOOLWINDOWTERMINALFROMRECEPTOREDITOR_H

#include "dctoolwindowbase.h"

#include <QtGui>

class DCCreator;
class DCCell;
class DCReceptor;
class DCEditableLabel;

class DCToolWindowTerminalFromReceptor : public DCToolWindowBase
{
    DCEditableLabel *d_textReceptorCellName;
    DCEditableLabel *d_textReceptorCellPath;
    DCEditableLabel *d_textReceptorName;
    DCEditableLabel *d_textAxonCellName;
    DCEditableLabel *d_textAxonCellPath;

    DCCell          *d_receptorCell;
    DCReceptor      *d_receptor;
    QString         d_receptorName;
    DCCell          *d_axonCell;
    QString         d_axonPagePathString;

    Q_OBJECT
public:
    explicit DCToolWindowTerminalFromReceptor(DCCreator *creator);
    virtual ~DCToolWindowTerminalFromReceptor();

    virtual int getPosPriority() const { return 2; }
    DCCell*     getAxonCell() const { return d_axonCell; }
    DCCell*     getReceptorCell() const { return d_receptorCell; }

    void        updateData(DCCell *receptorCell, DCReceptor *receptor, const QString &axonPagePath, DCCell *axonCell);
    void        resetData();
signals:
    
public slots:
    
};

#endif // DCTOOLWINDOWTERMINALFROMRECEPTOREDITOR_H
