//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#include "dcreceptor.h"

#include "dcvcomponent.h"
#include "dccell.h"
#include "dcvceditmodecursor.h"
#include "dcvceditmodeterminal.h"
#include "dcaxonterminal.h"

DCReceptor::DCReceptor(DCCell *owner) : TKReceptor(owner), d_vComponent(NULL), d_isTerminalVisible(true), d_editCursor(NULL)
{
}

DCReceptor::~DCReceptor()
{
    if (d_vComponent)
    {
        delete d_vComponent;
        d_vComponent = NULL;
    }
}

DCAxonTerminal* DCReceptor::getTarget() const
{
    return dynamic_cast<DCAxonTerminal*>(mTerminal);
}

DCCell* DCReceptor::getOwnerCell() const
{
    return dynamic_cast<DCCell*>(mOwner);
}

DCVComponent* DCReceptor::getVComponent() const
{
    return d_vComponent;
}

void DCReceptor::getViewReceptorOffsetPoint(float dx, float dy, float dz,float *x, float *y, float *z) const
{
    (void)dx; (void)dy; (void)dz;

    *x = 0;
    *y = 0;
    *z = 0;

    DCCell *cell = getOwnerCell();
    if (cell)
    {
        float cx,cz;
        cell->getViewHCrossPoint(dx,dz,&cx,&cz);
        *x = cx;
        *z = cz;
    }
}

void DCReceptor::registerEditCursor(DCVCEditModeCursor *cursor)
{
    d_editCursor = cursor;
}

void DCReceptor::unregisterEditCursor()
{
    d_editCursor = NULL;
}

void DCReceptor::setEditingCursorViewMatrix(const float matrix[])
{
    if (d_editCursor)
    {
        d_editCursor->getTerminal()->setViewMatrixForReceptorPoint(this, matrix);
    }
}
