//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 3/24/2012.
//
#ifndef DNSTORAGEIMPL_H
#define DNSTORAGEIMPL_H

class DNStorageDataSet;
class DNStorageDataSetQuery;
class DNStorageXYZVRecords;

class DNStorageImpl
{
public:
    static DNStorageImpl* create(const char *storagePath);

    virtual ~DNStorageImpl() {}
    virtual bool    setValue(const char *path, const char *key, float value) = 0;
    virtual float   getValue(const char *path, const char *key) = 0;
    virtual int     getCount(const char *path, const char *key) = 0;

    virtual int     countXYZVData(const char *path, const char *key) = 0;
    virtual bool    insertXYZVData(const char *path, const char *key, int index, float x, float y, float z,float v) = 0;
    virtual DNStorageXYZVRecords* queryXYZVData(const char *path, const char *key) = 0;
    virtual bool    deleteXYZVData(const char *path, const char *key) = 0;

    virtual bool    isValid() = 0;

    virtual bool    flush() = 0;

    virtual bool    startTransaction() = 0;
    virtual bool    commitTransaction() = 0;
    virtual bool    rollbackTransaction() = 0;
};

#endif // DNSOTRAGEIMPL_H
