//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#include "dcvterminalfromreceptormodehandler.h"

#include "dcvcpage.h"
#include "dcscene.h"
#include "dccreator.h"
#include "dcglwidget.h"

#include "dccell.h"
#include "dcreceptor.h"
#include "dcvceditmodecursor.h"
#include "dcglvisualizerwidget.h"

DCVTerminalFromReceptorModeHandler::DCVTerminalFromReceptorModeHandler(DCUIGraphicsScene *widget, DCCreator *creator, DCScene *scene, DCReceptor *editReceptor, DCVCEditModeCursor *cursor) :
    DCVEventHandler(widget, creator, scene), d_inResigingDrag(false), d_editReceptor(editReceptor), d_cursor(cursor)
{

}

DCVTerminalFromReceptorModeHandler::~DCVTerminalFromReceptorModeHandler()
{

}

int DCVTerminalFromReceptorModeHandler::getHandlerType() const
{
    return DCScene::DCV_EDITMODE_TERMINAL_FROM_RECEPTOR;
}

void DCVTerminalFromReceptorModeHandler::mousePressEvent(QGraphicsSceneMouseEvent *event)
{
    bool shift = event->modifiers() & Qt::ShiftModifier;

    QPointF mousePos = event->scenePos();

    d_draggedObject.assign(NULL);

    DCVComponent *obj = getView()->getObjectAt(mousePos.x(), mousePos.y(), d_cursor);
    if (!obj)
        return;

    DCVCPage *page = dynamic_cast<DCVCPage*>(obj->getPageBelonging());
    if (!page)
        return;

    if (obj !=  getScene()->getTerminalEditCursor() && obj != page)
            return;

    switch(getScene()->getPersMode())
    {
    case DCScene::DCV_PERSMODE_NAVIGATION:
        {
            if (obj != page)
            {
                getController()->selectPage(this, page, shift);
                if (obj->getIsSelectable())
                {
                    float pageX, pageZ;
                    getView()->toObjectCoordinateXZ(mousePos.x(), mousePos.y(), page, &pageX, &pageZ);
                    if (obj->startDrag(pageX, 0, pageZ, false))
                    {
                        getScene()->updateVisiblity();
                        getView()->requestRedraw(true);
                        d_draggedObject.assign(obj);
                        d_inResigingDrag = false;
                    }
                }
            }
            else
            {
                d_draggedObject.assign(obj);
                d_inResigingDrag = false;
            }
        }
        break;

    case DCScene::DCV_PERSMODE_PAGEEDIT:
        {
            float pageX, pageZ;
            getView()->toObjectCoordinateXZ(mousePos.x(), mousePos.y(), page, &pageX, &pageZ);
            if (obj->startDrag(pageX, 0, pageZ, false))
            {
                getScene()->updateVisiblity();
                getView()->requestRedraw(true);
            }
            d_draggedObject.assign(obj);
            d_inResigingDrag = false;
        }
        break;
    }

    event->accept();
}

void DCVTerminalFromReceptorModeHandler::mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)
{
    DCVComponent *obj = d_draggedObject.ref();

    if (!obj)
        return;

    DCVComponent *page = obj->getPageBelonging();
    if (!page)
        return;

    switch(getScene()->getPersMode())
    {
    case DCScene::DCV_PERSMODE_NAVIGATION:
        {
            getController()->changePersMode(this, DCCreator::DC_PERSMODE_PAGEEDIT);
            d_draggedObject.assign(NULL);
        }

        break;

    case DCScene::DCV_PERSMODE_PAGEEDIT:
         {
            if (obj == page)
            {
                getController()->changePersMode(this, DCCreator::DC_PERSMODE_NAVIGATION);
                d_draggedObject.assign(NULL);
            }
            else if (obj == d_cursor)
            {

                getController()->doCommandCancelAddAxonTerminal(this);
            }

        }
        break;
    }

    event->accept();
}

void DCVTerminalFromReceptorModeHandler::mouseMoveEvent(QGraphicsSceneMouseEvent *event, int clickTimeElapsed)
{
    QPointF mousePos = event->scenePos();
    QPointF mousePrevPos = event->lastScenePos();

    // This method will be called continuously while the mouse is moving.
    // Some process we want to execute here may become heavyer and it will affect the performance.
    // To privent this to affect the performance, we only execute the potentially heavyer
    // process 12.5 times in a second in maximum.
    static int lastCheckTime = 0;
    bool canProcessHeavyTask = clickTimeElapsed - lastCheckTime < 0 || clickTimeElapsed - lastCheckTime >= 80;
    if (canProcessHeavyTask)
        lastCheckTime = clickTimeElapsed;

    if (event->buttons() == Qt::LeftButton)
    {
        //dragging
        bool shift = event->modifiers() & Qt::ShiftModifier;
        float dx = mousePos.x() - mousePrevPos.x();
        float dy = mousePos.y() - mousePrevPos.y();


        if (canProcessHeavyTask && d_draggedObject.ref() && d_draggedObject.ref() != d_draggedObject.ref()->getPageBelonging())
        {
            d_draggedObject.ref()->setSelectable(false);
            DCVComponent *obj = getView()->getObjectAt(mousePos.x(), mousePos.y());
            d_draggedObject.ref()->setSelectable(true);
            DCCell *cell = d_editReceptor->getOwnerCell();

            if (d_cursor->getDropTarget() && d_cursor->getDropTarget() != obj)
            {
                getController()->unselectCellObject(this, d_cursor->getDropTarget());
                getController()->selectCellObject(this, cell->getVComponent());
            }
            if (obj && obj != obj->getPageBelonging() && obj->getPageBelonging() == d_draggedObject.ref()->getPageBelonging())
            {
                getController()->selectCellObject(this, obj, true);
                d_cursor->setDropTarget(obj);
            }
            else
            {
                d_cursor->setDropTarget(NULL);
            }
        }

        switch(getScene()->getPersMode())
        {
        case DCScene::DCV_PERSMODE_NAVIGATION:
            if (d_draggedObject.ref() && d_draggedObject.ref()->getPageBelonging() && d_draggedObject.ref() != d_draggedObject.ref()->getPageBelonging())
            {
                float pageX, pageZ;
                getView()->toObjectCoordinateXZ(mousePos.x(), mousePos.y(), d_draggedObject.ref()->getPageBelonging(), &pageX, &pageZ);

                if (d_draggedObject.ref()->dragging(pageX, 0, pageZ, false))
                {
                    DCGLWidget::singleton()->setCursor(Qt::OpenHandCursor);
                    getView()->requestRedraw(false);
                }
            }
            else if (!shift)
            {
                getController()->rotateScene(this, dy / 5.0, dx / 5.0);
            }
            else
            {
                getController()->translateBrowsModeScene(this, dx, dy);
            }
            break;

        case DCScene::DCV_PERSMODE_PAGEEDIT:
            if (d_draggedObject.ref() && d_draggedObject.ref()->getPageBelonging())
            {
                if (d_draggedObject.ref() == d_draggedObject.ref()->getPageBelonging())
                {
                    getController()->translateEditModeScene(this, dx, dy);
                }
                else
                {
                    float pageX, pageZ;
                    getView()->toObjectCoordinateXZ(mousePos.x(), mousePos.y(), d_draggedObject.ref()->getPageBelonging(), &pageX, &pageZ);
                    if (d_draggedObject.ref()->dragging(pageX, 0, pageZ, false))
                    {
                        DCGLWidget::singleton()->setCursor(Qt::OpenHandCursor);
                        getView()->requestRedraw(false);
                    }
                }
            }
            break;
        }
    }

    event->accept();
}

void DCVTerminalFromReceptorModeHandler::mouseReleaseEvent(QGraphicsSceneMouseEvent *event, bool wasDrag)
{
    bool shift = event->modifiers() & Qt::ShiftModifier;
    QPointF mousePos = event->scenePos();

    if (d_draggedObject.ref() && d_draggedObject.ref()->getPageBelonging())
    {
        float pageX, pageZ;
        getView()->toObjectCoordinateXZ(mousePos.x(), mousePos.y(), d_draggedObject.ref()->getPageBelonging(), &pageX, &pageZ);
        d_draggedObject.ref()->endDrag(pageX, 0, pageZ, d_inResigingDrag);
    }

    switch(getScene()->getPersMode())
    {
    case DCScene::DCV_PERSMODE_NAVIGATION:
    {
        DCVCPage *page = NULL;
        if (d_draggedObject.ref())
        {
            page = d_draggedObject.ref()->getPageBelonging();
        }

        if (wasDrag)
        {
            if (d_cursor->getDropTarget())
            {
                getController()->doCommandCommitAddAxonTerminal(this, d_cursor->getDropTarget()->getOwnerCell(), d_editReceptor);
            }
        }
        else
        {
            if (page)
            {
                getController()->selectPage(this, page, shift);
                d_cursor->changePageBelonging(page);
            }
            else
            {
                getController()->unselectPageAll(this);
            }
        }
    }
        break;

    case DCScene::DCV_PERSMODE_PAGEEDIT:
        if (wasDrag)
        {
            if (d_cursor->getDropTarget())
            {
                getController()->doCommandCommitAddAxonTerminal(this, d_cursor->getDropTarget()->getOwnerCell(), d_editReceptor);
            }
        }

        break;
    }

    getScene()->updateVisiblity();
    getView()->requestRedraw(true);
    event->accept();
}

void DCVTerminalFromReceptorModeHandler::wheelEvent(QGraphicsSceneWheelEvent  *event)
{
    if (event->isAccepted()) return;

    getController()->changeSceneScale(this, getScene()->getScale() + event->delta()/5);

    event->accept();
}

void DCVTerminalFromReceptorModeHandler::keyPressEvent(QKeyEvent *event)
{
    (void)event;

}

void DCVTerminalFromReceptorModeHandler::keyReleaseEvent(QKeyEvent *event)
{
    (void)event;

}

void DCVTerminalFromReceptorModeHandler::showContextMenu(const QPoint &pos)
{
    (void)pos;

}

void DCVTerminalFromReceptorModeHandler::selectedPageChanged(const void *requester)
{
    if (requester == this)
        return;

    QList<DCVCPage*> pages = getScene()->getSelectedPages();
    if (pages.length() == 0)
        return;

    if (d_cursor->getPageBelonging() != pages.at(0))
        d_cursor->changePageBelonging(pages.at(0));

}

