//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Oct-15, 2012.
//

#ifndef DCCELLCODETYPECOMBOBOX_H
#define DCCELLCODETYPECOMBOBOX_H

#include <QComboBox>

class DCCreator;
class DCCellCode;

class DCCellCodeTypeComboBox : public QComboBox
{
    Q_OBJECT

    DCCreator   *d_creator;
    DCCellCode  *d_cellCode;

    void    changeType(const QString& newType);

public:
    DCCellCodeTypeComboBox(DCCreator *creator, QWidget *parent = 0);
    virtual ~DCCellCodeTypeComboBox();

    void setEditingCellCode(DCCellCode* cellcode);
    void updateSelection();

signals:
    void typeChanged(const QString& newType);

public slots:
    void slotCurrentIndexChanged(const QString& newType);
    
};

#endif // DCCELLCODETYPECOMBOBOX_H
