﻿; (function ($) {var pr = {}; var areaList = []; var areaChildrenList = []; var DOCK = { TOP: 1, LEFT: 2, RIGHT: 4, BOTTOM: 8, FILL: 16, NONE: 0 }; var css = '<style type="text/css">		.windowBorder {		padding: 1px;		padding-top: 21px;		border: 1px black solid;		background-color: #F0F0F0;		overflow: hidden;		position: absolute;		width: 160px;		height: 140px;		top: 10px;		left: 10px;		box-shadow: 0px 0px 10px black ;	}	.windowBorder>.windowTitleBar {		background-color: #B9D1EA;		position: absolute;		top: 0px;		left: 0px;		right: 0px;		height: 21px;		padding-left: 6px;		color: black;	}	</style>'; $(function () { $('head').append(css); $(document).mouseup(pr.endDragging); $(document).mousemove(pr.moveDragging); $(window).resize(function () { for (key in areaList) { var area = areaList[key]; pr.layoutArea(area) } }) }); $.fn.dockedWindows = function () { this.each(function () { var id = pr.generateId(); $(this).data('areaId', id); $(this).css({ position: 'absolute', width: '', height: '', top: '0px', left: '0px', right: '0px', bottom: '0px', overflow: 'hidden', backgroundColor: 'gray' }); $(this).html('&nbsp;'); areaList[id] = this; areaChildrenList[id] = [] }); return (this) }; $.fn.setDockedWindow = function (area, config) { var defaults = { x: 10, y: 10, width: 300, maxWidth: 0, minWidth: 0, height: 200, maxHeight: 0, minHeight: 0, windowMode: "top | left | right | bottom | fill", caption: "Window", closeButton: true, docking: DOCK.NONE, windowStyle: true }; var setting = $.extend({}, defaults, config); var ret = []; this.each(function () { var setting2 = $.extend({}, setting, $(this).data()); var win = pr.createWindow(this, setting2.caption, setting2.windowStyle); for (key in setting2) $(win).data(key, setting2[key]); $(win).css('display', 'none'); $(win).data('parents', -1); $(win).data('mode', pr.calculateWindowMode(setting2.windowMode)); $(win).data('docking', pr.calculateWindowMode(setting2.docking)); if (area) { $(win).addToArea(area) } ret[ret.length] = win }); return $(ret) }; $.fn.addToArea = function (area) { var areaId = $(area).data('areaId'); $(this).each(function () { var parents = $(this).data('parents'); if (parents != areaId && pr.existsInKey(areaList, parents)) { pr.windowRemovedEvent(this, areaList(parents)) } $(this).appendTo(area); $(this).css('display', 'block'); pr.windowAddedEvent(this, area) }); return this }; pr.calculateWindowMode = function (value) { value = (value + " ").toLowerCase(); value = value.replace(/top/g, DOCK.TOP); value = value.replace(/left/g, DOCK.LEFT); value = value.replace(/right/g, DOCK.RIGHT); value = value.replace(/bottom/g, DOCK.BOTTOM); value = value.replace(/fill/g, DOCK.FILL); var exp = ""; for (i = 0; i < value.length; i++) { var char = value[i]; if ("0123456789|&".indexOf(char) >= 0) { exp += char } } try { return eval(exp) } catch (e) { throw "windowMode error"; } }; pr.createWindow = function (element, caption, style) { var win = $("<div>").wrapInner(element); if (style) { var title = $('<div class="windowTitleBar">' + caption + '</div>'); title.mousedown(function (e) { pr.beginDragging(e, win) }); $(win).addClass("windowBorder"); $(win).append(title) } else { $(win).css({ position: "absolute" }) } return win }; pr.existsInKey = function (array, key) { for (k in array) if (key == k) return true; return false }; pr.windowAddedEvent = function (window, area) { var id = $(area).data('areaId'); $(window).data('parents', id); areaChildrenList[id][areaChildrenList[id].length] = window; pr.layoutArea(area) }; pr.windowRemovedEvent = function (window, area) { var areaId = $(area).data('areaId'); $(window).data('parents', -1); for (var i = 0; i < areaChildrenList[id].length; i++) { if (areaChildrenList[id][i] == window) { areaChildrenList[id].splice(i, 1); break } } }; var draggingWindow = null; var draggingX = 10, draggingY = 10; pr.beginDragging = function (event, window) { if (draggingWindow != null) { pr.endDragging(null) } draggingWindow = window; draggingX = event.pageX - $(draggingWindow).offset().left; draggingY = event.pageY - $(draggingWindow).offset().top; pr.bringFront(window) }; pr.moveDragging = function (event) { var area = areaList[$(draggingWindow).data('parents')]; if (draggingWindow != null) { var dock = pr.analyzeMouseArea(event.pageX - $(area).position().left, event.pageY - $(area).position().top); $(draggingWindow).data('y', event.pageY - draggingY); $(draggingWindow).data('x', event.pageX - draggingX); if (dock == 0 || (dock & $(draggingWindow).data('mode')) != 0) { $(draggingWindow).data('docking', dock) } pr.layoutArea(areaList[draggingWindow.data('parents')]) } }; pr.endDragging = function (event) { draggingWindow = null }; pr.layoutArea = function (area) { var children = areaChildrenList[$(area).data('areaId')]; var leftBase = 0, rightBase = 0, topBase = 0, bottomBase = 0; for (i = 0; i < children.length; i++) { var zindex = i; var item = children[i]; var x = $(item).data('x'), y = $(item).data('y'), width = $(item).data('width'), height = $(item).data('height'); var minWidth = $(item).data('minWidth'), minHeight = $(item).data('minHeight'), maxWidth = $(item).data('maxWidth'), maxHeight = $(item).data('maxHeight'); var areaWidth = $(area).width(), areaHeight = $(area).height(); var docking = $(item).data('docking'); if (minWidth != 0) width = width < minWidth ? minWidth : width; if (minHeight != 0) height = height < minHeight ? minHeight : height; if (maxWidth != 0) width = width > maxWidth ? maxWidth : width; if (maxHeight != 0) height = height < maxHeight ? maxHeight : height; if (docking != DOCK.NONE) { if (docking == DOCK.TOP) { x = leftBase; y = topBase; width = areaWidth - leftBase - rightBase; topBase += height } else if (docking == DOCK.LEFT) { x = leftBase; y = topBase; height = areaHeight - topBase - bottomBase; leftBase += width } else if (docking == DOCK.RIGHT) { x = areaWidth - rightBase - width; y = topBase; height = areaHeight - topBase - bottomBase; rightBase += width } else if (docking == DOCK.BOTTOM) { x = leftBase; y = areaHeight - height - bottomBase; width = areaWidth - leftBase - rightBase; bottomBase += height } else if (docking == DOCK.FILL) { x = leftBase; y = topBase; width = areaWidth - leftBase - rightBase; height = areaHeight - topBase - bottomBase } } else { x = x + width > areaWidth ? areaWidth - width : x; y = y + height > areaHeight ? areaHeight - height : y; x = x < 0 ? 0 : x; y = y < 0 ? 0 : y; zindex += 100 } $(item).css({ top: y, left: x, width: width, height: height, zIndex: zindex }) } }; pr.analyzeMouseArea = function (x, y) { var cell = [[2, 1, 1, 1, 1, 1, 1, 1, 1, 4, 4], [2, 0, 0, 0, 0, 0, 0, 0, 0, 4, 4], [2, 0, 0, 0, 0, 0, 0, 0, 0, 4, 4], [2, 0, 0, 0, 0, 0, 0, 0, 0, 4, 4], [2, 0, 0, 0, 16, 16, 0, 0, 0, 4, 4], [2, 0, 0, 0, 16, 16, 0, 0, 0, 4, 4], [2, 0, 0, 0, 0, 0, 0, 0, 0, 4, 4], [2, 0, 0, 0, 0, 0, 0, 0, 0, 4, 4], [2, 0, 0, 0, 0, 0, 0, 0, 0, 4, 4], [2, 8, 8, 8, 8, 8, 8, 8, 8, 4, 4], [2, 8, 8, 8, 8, 8, 8, 8, 8, 4, 4]]; var areaWidth = $(area).width(), areaHeight = $(area).height(); var ret = cell[Math.floor((y / areaHeight) * 10)][Math.floor((x / areaWidth) * 10)]; if (ret != undefined) return ret; return 0; }
	pr.bringFront = function (win) { var areaId = $(win).data('parents'); var children = areaChildrenList[areaId]; for (var i = 0; i < children.length; i++) { if (win === children[i]) { children.splice(i, 1); children[children.length] = win; console.log(children); break } } }; pr.generateId=function (){return Math.floor(Math.random()*100000)}})(jQuery);