﻿/*
 * DrFx - FxCop Report Translator and Visualizer.
 * Copyright (C) 2010 Sasa Yuan
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */



using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Xml;

namespace Sasa.QualityTools.DrFx.Core.Translation
{
    /// <summary>
    /// 翻訳ルールを表します。
    /// </summary>
    public class DrFxRule
    {
        /// <summary>
        /// 解決方法を表すメッセージのコレクション。
        /// </summary>
        private List<Resolution> resolutions;



        /// <summary>
        /// FxCop ルールのチェック ID。
        /// </summary>
        public string CheckId { get; set; }

        /// <summary>
        /// FxCop ルールのカテゴリ。
        /// </summary>
        public string Category { get; set; }

        /// <summary>
        /// FxCop ルール名。
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// ルール違反の解決方法を表すオブジェクトのコレクション。
        /// </summary>
        public IList<Resolution> Resolutions
        {
            get
            {
                return this.resolutions;
            }
        }



        /// <summary>
        /// 新しいインスタンスを初期化します。
        /// </summary>
        public DrFxRule()
        {
            this.resolutions = new List<Resolution>();
        }
    }
}
